<?php
    include_once ('../db_connect.php');
	include_once ('../functions.php');
	
	if(!isset($_SESSION['uname'])){
		header("Location: ../login.php");
	}	
     
    $id = (isset($_GET['id'])) ? intval($_GET['id']) : 1;

    if(!$row = get_poll($id)){
        exit('not found');
    }  
	
	$total_votes = total_votes($id);
	
	require('fpdf/fpdf.php');
	
	class PDF extends FPDF
	{	
	// Page footer
	function Footer()
	{
		// Position at 1.5 cm from bottom
		$this->SetY(-15);
		// Arial italic 8
		$this->SetFont('Arial','I',8);
		// Page number
		$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
	}
	}
		
	$pdf = new PDF();
	$pdf->AliasNbPages();
	$pdf->AddPage();
	$pdf->SetFont('Arial','B',16);
	$pdf->Cell(40,10,$row['title']);
	$pdf->Ln(10);
	$pdf->SetFont('Arial','B',12);
	$pdf->Cell(40,10,'Total Votes: '.$total_votes);
	$pdf->Ln(15);
	$pdf->SetFont('Arial','',12);
	foreach (poll_options($id) as $option) {
		if($option['rates']!=""){ $pdf->Cell(40,10,$option['title'].': '.$option['rates']." (".$option['percent']."%)"); } else{ $pdf->Cell(40,10,$option['title'].': 0'); }
		//$pdf->Cell(40,10,$option['title'].': '.$option['rates']);
		$pdf->Ln(10);
	}
	$filename=$row['title'].".pdf";
	$filename=preg_replace('/[^a-zA-Z 0-9.]+/', '', $filename); //removes anything that isn't a letter, number, dot or space
	$pdf->Output($filename,'D');				
?>